DECLARE SUB MultiTasking.Driver (action%)
DECLARE SUB MultiTask.Driver (action%)
DECLARE SUB DrawAll (cdx%, cdy%)
DECLARE SUB w (a$, X%, Y%, Co%, Bkgd%, Shadow%)
'$INCLUDE: 'qb.bi'
DEFINT A-Z
'$DYNAMIC
DECLARE SUB CDPLAYER (Fun$, lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$)
DECLARE SUB box (bcol%, X%, Y%, x2%, y2%, title$, tc%, tbg%, tsh%, shwmen%, clse%, minm%)
DECLARE SUB button2 (x1%, y1%, InOut%, txt$, mc%)
DECLARE SUB mousedriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseHide ()
DECLARE SUB MouseShow ()
DECLARE SUB MouseStatus (Lb%, Rb%, xMouse%, yMouse%)
DECLARE FUNCTION MouseLimit% (MiniX%, MiniY%, MaxiX%, MaxiY%)
DECLARE FUNCTION MouseInOut% (Left%, Up%, text1$, InOut%)
DECLARE FUNCTION mouseinit% ()
DECLARE SUB Place.Icon (X%, Y%, filename$)
'DECLARE SUB w (a$, X%, Y%, Co%, Bkgd%, Shadow%)
'Begin CD Routines
DECLARE SUB SCDAudioStatus (Paused%, start&, ending&)
DECLARE SUB SCDQInfo (track%, RTTrack&, RTDisk&)
DECLARE SUB SCDTrackInfo (track%, start&, ctrl%)
DECLARE SUB SCDDiskInfo (Low%, High%, Leadout&)
DECLARE FUNCTION SCDMediaChanged% ()
DECLARE FUNCTION SCDDeviceStatus% ()
DECLARE SUB SCDGetChannel (Ch0%, Vol0%, Ch1%, Vol1%, Ch2%, Vol2%, Ch3%, Vol3%)
DECLARE SUB RTQInfo (track%, RTTrack&, RTDisk&, lowest%, highest%, r1%, c1%, c2%)
DECLARE SUB HSGtoRBA (HSGSector&, RBAMin%, RBASec%, RBAFrm%)
DECLARE FUNCTION RBAtoHSG& (RBAMin%, RBASec%, RBAFrm%)
DECLARE FUNCTION SCDLocateHead& ()
DECLARE SUB Prepcb (code%)
DECLARE SUB Preprh (command%)
DECLARE SUB Call10 ()
DECLARE SUB CDError ()
DECLARE SUB InitDrives ()
DECLARE SUB GetDrives (numdrives%, first%)
DECLARE FUNCTION CheckMSCDEX% (major$, minor$)
DECLARE SUB Byte (Expression&, b1$, b2$, b3$, b4$)
DECLARE FUNCTION BitCheck% (Bit%, DecNum%)
DECLARE FUNCTION lbyte% (word%)
DECLARE FUNCTION hbyte% (word%)
DECLARE SUB GetTrack (lowest%, highest%, max&) 'gets track info and puts it in trackinfo()
DECLARE SUB DisplayTime (mm%, ss%, ff%)
DECLARE SUB SCDplay (BeginSec&, LengthSec&)
DECLARE SUB SCDPause ()
DECLARE SUB DisplayTrackInfo (lowest%, highest%)
DECLARE SUB DisplayTrackPercent (RTTrack&, track%, lowest%, highest%)
DECLARE SUB KeyHandler (kbd$, lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$)
DECLARE SUB SCDClose ()
DECLARE SUB SCDEject ()
DECLARE SUB SCDReset ()
DECLARE SUB SCDResume ()
DECLARE SUB ShowTime (row%, col%)
DIM SHARED inregsx AS RegTypeX
DIM SHARED outregsx AS RegTypeX
TYPE tracktype
	start AS LONG
	length AS LONG
	ctrlinfo AS INTEGER
END TYPE

TYPE disktype
	Low     AS INTEGER
	High    AS INTEGER
	Leadout AS LONG
END TYPE

'$DYNAMIC
'----------------------------------------------------------------
'COMMON SHARED Baseport%             'for Sound Blaster card
'COMMON SHARED SBMyVol%              'volume setting
'COMMON SHARED CDDEBUG%
'env/status vars
COMMON SHARED CDDoorOpen%           'is cd tray/door open? Door in CDLIB
COMMON SHARED playing AS INTEGER    'is CD playing?
COMMON SHARED Paused AS INTEGER
COMMON SHARED Stopped AS INTEGER
COMMON SHARED Drive AS INTEGER      'default drive

COMMON SHARED drv%                  'current drive
COMMON SHARED rhlength%             'length of request header
COMMON SHARED cblength%             'length of control block
COMMON SHARED max&                  'length of control block
COMMON SHARED numdrives AS INTEGER
COMMON SHARED first AS INTEGER      'drive letter of first CD drive : int
DIM SHARED drivearray(X, Y) AS INTEGER
DIM SHARED rh(z) AS STRING * 1      'request header - dynamic array
DIM SHARED cb(z) AS STRING * 1      'command block  - dynamic array
DIM SHARED trackinfo(z) AS tracktype
DIM SHARED diskinfo(z) AS disktype
DIM SHARED Button.Button(650)
DIM SHARED MOUSE$
DIM SHARED cdx%, cdy%
DIM SHARED BehindCD(140, 140)
DIM SHARED BehindDrag(140, 140)
DIM SHARED trak$
DIM SHARED pause%

MOUSE$ = SPACE$(57)
FOR I% = 1 TO 57
	READ a$
	H$ = CHR$(VAL("&H" + a$))
	MID$(MOUSE$, I%, 1) = H$
NEXT I%
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

'End CD Routines


'Some More CD Routines
CONST frameto100 = 1.333
CONST true = 1, false = 0
CONST skiplength& = 750&
paused1% = false
CDDoorOpen% = false
CDDEBUG% = false:  'A crude form of error correction in subs
max& = 0:
trlen& = 1
Baseport% = &H210
SBMyVol% = 8
vbar$ = CHR$(179)
r1 = 5: c1 = 1: c2 = 45: 'position of track info
'-----------------------------------END Definitions Block ------
top:
CDDEBUG% = false:  'DO NOT remove
instruction$ = " " + CHR$(25) + " LAST_TR  " + CHR$(17) + " REW  <=PAUSE/RESUME 5=>   "
instruction$ = instruction$ + CHR$(16) + " FF  " + CHR$(24) + " NEXT_TR "
instruction$ = instruction$ + vbar$ + "0 EJECT" + vbar$ + " Enter STOP"
IF CheckMSCDEX(major$, minor$) = false THEN SYSTEM
LOCATE 3, 1
InitDrives
drv% = drivearray(Drive, 1): 'drive D means drv%=3
status% = SCDDeviceStatus
SCREEN 12
MouseShow
SCDQInfo track%, RTTrack&, RTDisk&

SCDDiskInfo lowest%, highest%, max&
'door is open
status% = SCDDeviceStatus
CDDoorOpen% = BitCheck(0, status%)
IF CDDoorOpen% THEN
   SCDClose
END IF
'no cd in tray
IF highest% = 0 THEN
END IF
HSGtoRBA max&, mm, ss, ff
GetTrack lowest%, highest%, max&
'DisplayTrackInfo lowest%, highest%
currtrack = lowest%: track% = lowest%
start& = trackinfo(lowest%).start
IF start& = -150 THEN
END IF
'avoid General Failure error
'IF playing = false THEN
'    SCDplay start&, max&
'END IF
'That's all for the CD-PLAYER ITSELF!

SCREEN 12
Format$ = "##"
cdx = 100
cdy = 100
MouseHide
DrawAll cdx, cdy
MouseShow
MouseShow
DO
	IF trackold% <> track% THEN
		LINE (cdx% + 59, cdy% + 39)-(cdx% + 230, cdy% + 65), 8, BF
		LINE (cdx% + 61, cdy% + 41)-(cdx% + 231, cdy% + 66), 15, B
		LINE (cdx% + 60, cdy% + 40)-(cdx% + 230, cdy% + 65), 0, BF
		trackold% = track%
		CLOSE #2
		OPEN "TMP\CD_P.TMP" FOR OUTPUT AS #2
			PRINT #2, track%
		CLOSE #2
		OPEN "TMP\CD_P.TMP" FOR INPUT AS #2
			INPUT #2, trak$
		CLOSE #2
		w "Track: " + trak$ + "", cdx + 110, cdy% + 50, 15, 0, 0
	END IF
	SCDQInfo track%, RTTrack&, RTDisk& 'update playing
	MouseStatus Lb%, Rb%, cx%, dx%
	IF Lb% = -1 THEN
		IF MouseLimit(cdx% + 10, cdy% + 100, 80, 20) = -1 THEN
			MouseHide
			button2 cdx% + 10, cdy% + 100, 1, "Play", 0
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
			LOOP WHILE Lb% = -1
			MouseHide
			button2 cdx% + 10, cdy% + 100, 0, "Play", 0
			MouseShow
			SCDQInfo track%, RTTrack&, RTDisk& 'update playing
			CDPLAYER "PLAY", lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
		ELSEIF MouseLimit(cdx% + 100, cdy% + 100, 80, 20) = -1 THEN
			MouseHide
			button2 cdx% + 100, cdy% + 100, 1, "Stop", 0
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
			LOOP WHILE Lb% = -1
			MouseHide
			button2 cdx% + 100, cdy% + 100, 0, "Stop", 0
			MouseShow
			CDPLAYER "STOP", lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
		ELSEIF MouseLimit(cdx% + 190, cdy% + 100, 80, 20) = -1 THEN
			MouseHide
			button2 cdx% + 190, cdy% + 100, 1, "Pause", 0
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
			LOOP WHILE Lb% = -1
			MouseHide
			button2 cdx% + 190, cdy% + 100, 0, "Pause", 0
			MouseShow
			CDPLAYER "PAUSE", lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
		 ELSEIF MouseLimit(cdx% + 26, cdy% + 130, 65, 20) = -1 THEN
			MouseHide
			button2 cdx% + 26, cdy% + 130, 1, ">>", 0
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
			LOOP WHILE Lb% = -1
			MouseHide
			button2 cdx% + 26, cdy% + 130, 0, ">>", 0
			MouseShow
			CDPLAYER "NEXT", lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
		 ELSEIF MouseLimit(cdx% + 100, cdy% + 130, 90, 20) = -1 THEN
			MouseHide
			button2 cdx% + 100, cdy% + 130, 1, "Eject", 0
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
			LOOP WHILE Lb% = -1
			MouseHide
			button2 cdx% + 100, cdy% + 130, 0, "Eject", 0
			MouseShow
			CDPLAYER "EJECT", lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
		 ELSEIF MouseLimit(cdx% + 200, cdy% + 130, 65, 20) = -1 THEN
			MouseHide
			button2 cdx% + 200, cdy% + 130, 1, "<<", 0
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
			LOOP WHILE Lb% = -1
			MouseHide
			button2 cdx% + 200, cdy% + 130, 0, "<<", 0
			MouseShow
			CDPLAYER "PREV", lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$
		  ELSEIF MouseLimit(cdx%, cdy%, 260, 15) = -1 THEN
			MouseHide
			PUT (cdx%, cdy%), BehindCD, PSET
			MouseShow
			DO
				MouseStatus Lb%, Rb%, cx%, dx%
				IF cx% > 332 THEN
					cx% = 330
				END IF
				IF dx% > 277 THEN
					dx% = 275
				END IF
				MouseHide
				GET (cx%, dx%)-(cx + 302, dx% + 200), BehindDrag
				LINE (cx%, dx%)-(cx% + 300, dx% + 200), 7, B
				MouseShow
				DO
					MouseStatus Lb%, Rb2%, cx2%, dx2%
					IF cx2% > 332 THEN
						cx2% = 330
					END IF
					IF dx2% > 277 THEN
						dx2% = 275
					END IF
			   
				LOOP WHILE cx2% = cx% AND dx2% = dx% AND Lb% = -1
				MouseHide
				PUT (cx%, dx%), BehindDrag, PSET
				MouseShow
				cdx = cx%: cdy = dx%
			LOOP WHILE Lb% = -1
			MouseHide
			DrawAll cdx, cdy
			MouseShow
		  ELSEIF MouseLimit(cdx% + 265, cdy% + 4, 15, 13) = -1 THEN
				MouseHide
				Place.Icon cdx% + 266, cdy% + 4, "system\gf11__.___"
				MouseShow
				DO
					MouseStatus Lb%, Rb2%, cx2%, dx2%
				LOOP WHILE Lb% = -1
				MouseHide
				Place.Icon cdx% + 266, cdy% + 4, "system\gf10__.___"
				MouseShow
				MultiTasking.Driver 1
				SYSTEM
		  ELSEIF MouseLimit(cdx% + 282, cdy% + 4, 18, 13) = -1 THEN
				'Close!
				MouseHide
				Place.Icon cdx% + 282, cdy% + 4, "icons\title_03.gfx"
				MouseShow
				DO
					MouseStatus Lb%, Rb2%, cx2%, dx2%
				LOOP WHILE Lb% = -1
				MouseHide
				Place.Icon cdx% + 282, cdy% + 4, "icons\title_02.gfx"
				MouseShow
				MultiTasking.Driver 2
				SYSTEM
		 END IF
	END IF
LOOP
'IF Rb% = -1 THEN
'        IF MouseLimit(FootX%, FootY%, 400, 50) = -1 THEN
'            DO

REM $STATIC
DEFSNG A-Z
FUNCTION BitCheck% (Bit%, DecNum%)
'This function checks if a certain bit in a number is set
'
'ARGS:  Bit%                - The number of the bit you want to check (0-15)
'       DecNum%             - The number you want to check
'RET:   Function Value      - True (1) = bit is set
'                             False (0) = bit not set

IF (DecNum% AND 2 ^ Bit%) THEN
		BitCheck% = true
	ELSE
		BitCheck% = false
	END IF
END FUNCTION

DEFINT A-Z
SUB box (bcol%, X%, Y%, x2%, y2%, title$, tc%, tbg%, tsh%, shwmen, clse, minm)

LINE (X%, Y%)-(x2%, y2%), bcol%, BF
LINE (X% + 1, Y% + 1)-(x2% - 1, y2% - 1), 15, B
LINE (X% + 1, y2% - 1)-(x2%, y2% - 1), 8, B
LINE (X%, y2%)-(x2%, y2%), 0, B
LINE (x2% - 1, Y% + 1)-(x2% - 1, y2% - 1), 8, B
LINE (x2%, Y%)-(x2%, y2% - 1), 0, B

LINE (X% + 3, Y% + 3)-(x2% - 3, Y% + 15), 1, BF

w title$, X% + 10, Y% + 6, tc%, tbg%, tsh%

IF clse = 1 THEN
   Place.Icon x2% - 19, Y% + 4, "icons\title_02.gfx"
END IF
 IF minm = 1 THEN
	Place.Icon x2% - 34, Y% + 4, "system\gf10__.___"
 END IF

END SUB

SUB button2 (x1, y1, InOut, txt$, mc)

'CALL MouseHide
x2 = LEN(txt$) * 8 + x1 + 26 + 26
y2 = y1 + 8 + 15
IF InOut = 0 THEN c1 = 15: c2 = 8 ELSE c1 = 8: c2 = 15
LINE (x1 + 2, y1 + 2)-(x2 - 2, y2 - 2), 7, BF
IF mc = 1 THEN
LINE (x1 + 1, y1 + 1)-(x2 - 1, y2 - 1), 0, B
LINE (x1 + 1, y1)-(x2 - 1, y1), 0
LINE (x1 + 1, y2)-(x2 - 1, y2), 0
LINE (x1, y1 + 1)-(x1, y2 - 1), 0
LINE (x2, y1 + 1)-(x2, y2 - 1), 0
END IF
LINE (x2 - 2, y1 + 3)-(x1 + 2, y1 + 2), c1, BF
LINE -(x1 + 3, y2 - 2), c1, BF
LINE (x1 + 2, y2 - 2)-(x2 - 2, y2 - 2), c2
LINE -(x2 - 2, y1 + 2), c2
LINE (x2 - 3, y2 - 3)-(x2 - 3, y2 - 3), c2
LINE -(x2 - 3, y1 + 3), c2
IF InOut > 0 THEN x1 = x1 + 1: y1 = y1 + 1
w txt$, x1 + 26, y1 + 8, 0, 0, 0
'CALL MouseShow

END SUB

DEFSNG A-Z
SUB Byte (Expression&, b1$, b2$, b3$, b4$)
'This subroutine seperates a 4-byte number into its components.
'
'ARGS:  Expression& - 4-byte number
'       b1$         - string to store first byte in
'       b2$         - string to store second byte in
'       b3$         - string to store third byte in
'       b4$         - string to store fourth byte in
'RET:   Expression& - unchanged
'       b1$ - b4$   - containing the bytes

ts& = Expression&
b1$ = CHR$(ts& \ 2 ^ 24)
ts& = ts& MOD 2 ^ 24
b2$ = CHR$(ts& \ 2 ^ 16)
ts& = ts& MOD 2 ^ 16
b3$ = CHR$(ts& \ 2 ^ 8)
b4$ = CHR$(ts& MOD 2 ^ 8)
END SUB

SUB Call10 STATIC
inregsx.ax = &H1510
inregsx.cx = drivearray(Drive, 1)
inregsx.es = VARSEG(rh(1))
inregsx.bx = VARPTR(rh(1))

CALL INTERRUPTX(&H2F, inregsx, outregsx)

' Check Error bit of Status field
IF BitCheck(7, ASC(rh(5))) = true THEN
 IF ASC(rh(4)) = 2 THEN
	CDDoorOpen% = true
 ELSE
	'CDError
 END IF
END IF
END SUB

DEFINT A-Z
SUB CDPLAYER (Fun$, lowest%, highest%, track%, max&, RTTrack&, RTDisk&, instruction$)
currtrack = track%
IF Fun$ = "NEXT" THEN
	currtrack = currtrack + 1
	IF currtrack > highest% THEN currtrack = lowest%
	start& = trackinfo(currtrack).start
	SCDPause
	SCDplay start&, max& - start&
ELSEIF Fun$ = "PREV" THEN
	currtrack = currtrack - 1
	IF currtrack < lowest% THEN currtrack = highest%
	start& = trackinfo(currtrack).start
	SCDPause
	SCDplay start&, max& - start&
ELSEIF Fun$ = "PAUSE" THEN
	IF Paused% = true THEN
		'SCDplay start&, max&
		SCDResume
	ELSE
		SCDPause
	END IF
ELSEIF Fun$ = "STOP" THEN
	SCDPause
	SCDReset
ELSEIF Fun$ = "EJECT" THEN
  IF CDDoorOpen% <> true THEN
	  SCDPause
	  SCDEject
  ELSE
	 SCDPause
	 SCDEject
  END IF
ELSEIF Fun$ = "PLAY" THEN
	SCDplay start&, max&
END IF

END SUB

SUB CDSystemInitS
'Initializes our CD-ROM Library
'
'ARGS:  none
'RET:   Updates all environment variables


IF CheckMSCDEX(major$, minor$) THEN
	ELSE
END IF

InitDrives

IF SCDMediaChanged >= 0 THEN
	SCDReset
END IF


status% = SCDDeviceStatus

IF BitCheck(4, status%) = false THEN
	PRINT "Your default drive cannot play Audio CDs!"
	SYSTEM
END IF

IF CDDoorOpen% THEN
	SCDReset
	Paused = false
	Stopped = true
	playing = false
END IF

END SUB

DEFSNG A-Z
FUNCTION CheckMSCDEX% (major$, minor$)
'Check if MSCDEX is installed
'
'ARGS:  two strings which will hold the major and minor
'       version numbers
'RET:   major$          - major version number
'       minor$          - minor version number
'       function value  - True = MSCDEX installed
'                         False = MSCDEX not installed

inregsx.ax = &H150C
inregsx.bx = &H0
CALL INTERRUPTX(&H2F, inregsx, outregsx)

IF hbyte(outregsx.bx) = 0 THEN
		CheckMSCDEX = false
	ELSE
		CheckMSCDEX = true
		major$ = LTRIM$(STR$(hbyte(outregsx.bx)))
		minor$ = LTRIM$(STR$(lbyte(outregsx.bx)))
	END IF
END FUNCTION

DEFINT A-Z
SUB DisplayTime (mm, ss, ff)
mmfmt$ = "00:00.00"
IF mm < 10 THEN
	MID$(mmfmt$, 2, 1) = LTRIM$(STR$(mm))
ELSE
	MID$(mmfmt$, 1, 2) = LTRIM$(STR$(mm))
END IF
'begin debug code
'IF ss < 0 THEN LOCATE 18, 60: PRINT ss
'end debug code
IF ss = -2 THEN ss = 58
IF ss = -1 THEN ss = 59
IF ss < 10 THEN
	MID$(mmfmt$, 5, 1) = LTRIM$(STR$(ss))
ELSE
	MID$(mmfmt$, 4, 2) = LTRIM$(STR$(ss))
END IF
ff = ff * frameto100
IF ff < 10 THEN
	MID$(mmfmt$, 8, 1) = LTRIM$(STR$(ff))
ELSE
	MID$(mmfmt$, 7, 2) = LTRIM$(STR$(ff))
END IF
PRINT mmfmt$;

END SUB

SUB DisplayTrackInfo (lowest%, highest%)

'ctrlinfo byte breakdown
'  76543210 <- bit #
'  00x00000  - 2 audio channels without pre-emphasis
'  00x10000  - 2 audio channels with pre-emphasis
'  10x00000  - 4 audio channels without pre-emphasis
'  10x10000  - 4 audio channels with pre-emphasis
'  01x00000  - data track
'  01x10000  - Reserved
'  11xx0000  - Reserved
'  xx0x0000  - digital copy prohibited
'  xx1x0000  - digital copy permitted

LOCATE 8, 1
COLOR 14, 6
PRINT "track#", "Start Time", "Track Length", "Track Information"
LOCATE 9, 1
VIEW PRINT 9 TO 21
COLOR 7, 0
FOR trk% = lowest% TO highest%
	PRINT "TRACK="; trk%,
	s& = trackinfo(trk%).start
	HSGtoRBA s&, mm%, ss%, ff%
	DisplayTime mm%, ss%, ff%: PRINT "",
	l& = trackinfo(trk%).length
	HSGtoRBA l&, mm%, ss%, ff%
	DisplayTime mm%, ss%, ff%: PRINT "",
	c% = trackinfo(trk%).ctrlinfo
	DigCopyOK = BitCheck(5, c%)
	IF DigCopyOK THEN
		PRINT "=:)";
	ELSE
		PRINT "(c)";
	END IF
	FourChnl = BitCheck(7, c%) AND 1 XOR BitCheck(6, c%)
	IF FourChnl THEN
		PRINT "4Chnl";
		IF BitCheck(4, c%) THEN
			PRINT "Emph";
		ELSE
			PRINT "Norm";
		END IF
	END IF
	TwoChnl = (1 XOR BitCheck(7, c%)) AND (1 XOR BitCheck(6, c%))
	IF TwoChnl THEN
		PRINT "2Chnl";
		IF BitCheck(4, c%) THEN
			PRINT "Emph";
		ELSE
			PRINT "Norm";
		END IF
	END IF
	AudioTrack = 1 XOR BitCheck(6, c%)
	IF AudioTrack THEN
		PRINT "Audio";
	ELSE
		PRINT "Data ";
	END IF
	PRINT
NEXT trk%
VIEW PRINT
END SUB

SUB DisplayTrackPercent (RTTrack&, track%, lowest%, highest%)
	'graphically show track %
	IF track% >= lowest% AND track% <= highest% THEN
		trlen& = trackinfo(track%).length
		trackpercent = INT(RTTrack& / trlen& * 100)
		LOCATE 22, 1: PRINT "Track" + STR$(track%) + ":" + STR$(trackpercent) + "% "
		LOCATE 23, 1:
		PRINT STRING$(trackpercent \ 2, 219) + STRING$(50 - trackpercent \ 2, 176)
	END IF

END SUB

SUB DrawAll (cdx%, cdy%)
GET (cdx%, cdy%)-(cdx + 300, cdy% + 200), BehindCD
box 7, cdx%, cdy%, cdx + 300, cdy% + 200, "CD Player", 15, 0, 0, 0, 1, 1
LINE (cdx% + 59, cdy% + 39)-(cdx% + 230, cdy% + 65), 8, BF
LINE (cdx% + 61, cdy% + 41)-(cdx% + 231, cdy% + 66), 15, B
LINE (cdx% + 60, cdy% + 40)-(cdx% + 230, cdy% + 65), 0, BF
w "Track: " + trak$ + "", cdx + 110, cdy% + 50, 15, 0, 0
button2 cdx% + 10, cdy% + 100, 0, "Play", 0
button2 cdx% + 100, cdy% + 100, 0, "Stop", 0
button2 cdx% + 190, cdy% + 100, 0, "Pause", 0

button2 cdx% + 26, cdy% + 130, 0, ">>", 0
button2 cdx% + 100, cdy% + 130, 0, "Eject", 0
button2 cdx% + 200, cdy% + 130, 0, "<<", 0

END SUB

SUB GetBLASTER (DMA%, Baseport%, IRQ%)
' This subroutine parses the BLASTER environment string and returns settings.
IF LEN(ENVIRON$("BLASTER")) = 0 THEN
	COLOR 14, 4: LOCATE 21, 1
	Baseport% = false: 'signal error
	PRINT "BLASTER environment variable not set."
	EXIT SUB
END IF
FOR length% = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), length%, 1)
	  CASE "A"
		Baseport% = VAL("&H" + MID$(ENVIRON$("BLASTER"), length% + 1, 3))
	  CASE "I"
		IRQ% = VAL(MID$(ENVIRON$("BLASTER"), length% + 1, 1))
	  CASE "D"
		DMA% = VAL(MID$(ENVIRON$("BLASTER"), length% + 1, 1))
   END SELECT
NEXT
END SUB

DEFSNG A-Z
SUB GetDrives (numdrives%, first%)
' Gets the number of drives installed on a system and
' the drive letter number of the first drive
'
' ARGS: two integers which will hold the returned
'       values
' RET:  numdrives%      - total number of CD-ROMs
'       first%          - drive letter number of first
'                         drive on system

inregsx.ax = &H1500
inregsx.bx = &H0
inregsx.cx = &H0

CALL INTERRUPTX(&H2F, inregsx, outregsx)

numdrives% = outregsx.bx
first% = outregsx.cx
END SUB

DEFINT A-Z
SUB GetTrack (lowest%, highest%, max&) STATIC
REDIM trackinfo(lowest% TO highest%) AS tracktype
'LOCATE 9, 1: COLOR 15, 3
' GETTRACK
' pre: lowest and highest track numbers
' ret: trackinfo array with start,length, and ctrlinfo in HSG format

FOR trk% = lowest% TO highest%
	'PRINT "TRACK="; trk%,
	SCDTrackInfo trk%, start&, ctrl%
	trackinfo(trk%).ctrlinfo = ctrl%

	trackinfo(trk%).start = start&
	'PRINT "track start="; trackinfo(trk%).start,
	IF trk% <> lowest% THEN
		trackinfo(trk% - 1).length = trackinfo(trk%).start - trackinfo(trk% - 1).start
	END IF

	'PRINT "track control info"; trackinfo(trk%).ctrlinfo
	AudioTrack = 1 XOR BitCheck(6, trackinfo(trk%).ctrlinfo)
	'IF NOT AudioTrack AND highest% = lowest% THEN
	'    LOCATE 21, 1: COLOR 14, 4
	'    PRINT "CD-ROM found... Exiting.": END
	'END IF

NEXT trk%
trackinfo(highest%).length = max& - trackinfo(highest%).start
END SUB

DEFSNG A-Z
FUNCTION hbyte% (word%)
'Returns the high byte of a 2-byte number (INNTEGER)
'
'ARGS:  word%               - 2-byte number (INTEGER)
'RET:   Function Value      - High byte or word%

IF word% >= 0 THEN
		hbyte% = word% \ 256
	ELSE
		hbyte% = (65536 + word%) \ 256
	END IF
END FUNCTION

SUB HSGtoRBA (HSGSector&, RBAMin%, RBASec%, RBAFrm%)
ts& = HSGSector&
RBAMin% = ts& \ 4500
ts& = ts& MOD 4500
RBASec% = ts& \ 75
ts& = ts& MOD 75
RBAFrm% = ts&
END SUB

SUB InitDrives
' Modifies the array passed to it and stores the Drive
' Management Structure in it
'
' ARGS: An integer array which will hold the returned
'       values
' RET:  drivearray()    - Drive Management Structure
'    ** Drive           - Sets default drive to 1 (Drive is init. HERE!)

GetDrives numdrives%, first%

DIM temp1(1 TO numdrives% * 5) AS STRING * 1
DIM temp2(1 TO numdrives%) AS STRING * 1
REDIM drivearray(1 TO numdrives%, 1 TO 2) AS INTEGER

inregsx.ax = &H1501
inregsx.es = VARSEG(temp1(1))
inregsx.bx = VARPTR(temp1(1))
CALL INTERRUPTX(&H2F, inregsx, outregsx)

inregsx.ax = &H150D
inregsx.es = VARSEG(temp2(1))
inregsx.bx = VARPTR(temp2(1))
CALL INTERRUPTX(&H2F, inregsx, outregsx)

FOR X = 1 TO numdrives%
	drivearray(X, 1) = ASC(temp2(X))
	drivearray(X, 2) = ASC(temp1(1 + (X - 1) * 5))
NEXT X
Drive = 1
END SUB

FUNCTION lbyte% (word%)
'Returns the low byte of a 2-byte number (INNTEGER)
'
'ARGS:  word%               - 2-byte number (INTEGER)
'RET:   Function Value      - Low byte or word%

IF word% >= 0 THEN
		lbyte% = word% MOD 256
	ELSE
		lbyte% = (65536 + word%) MOD 256
	END IF
END FUNCTION

DEFINT A-Z
'DEFLNG A-Z
SUB mousedriver (ax%, bx%, cx%, dx%)

  DEF SEG = VARSEG(MOUSE$)
  MOUSE% = SADD(MOUSE$)
  CALL ABSOLUTE(ax%, bx%, cx%, dx%, MOUSE%)

END SUB

SUB MouseHide
 ax% = 2
 mousedriver ax%, 0, 0, 0
END SUB

FUNCTION mouseinit%
  ax% = 0
  mousedriver ax%, 0, 0, 0
  mouseinit% = ax%
END FUNCTION

'/* This function handles the mouse when it is clicking a button           */'
FUNCTION MouseInOut (Left, Up, text1$, InOut)

MouseInOutx = 0
Right = LEN(text1$) * 8 + 52: Down = 23

CALL button2(Left, Up, 1, text1$, 0)
DO
	CALL MouseStatus(LeftButton, RightButton, xMouse, yMouse)
	IF InOut = 1 THEN
		IF MouseLimit(Left, Up, Right, Down) = 0 THEN
			CALL MouseHide
			CALL button2(Left, Up, 0, text1$, 0)
			CALL MouseShow
			MouseInOutx = 2: EXIT FUNCTION
		END IF
	END IF
LOOP UNTIL LeftButton = 0
CALL button2(Left, Up, 0, text1$, 0)

END FUNCTION

'/* This function checks if the mouse is located in a given area           */'
FUNCTION MouseLimit (MiniX, MiniY, MaxiX, MaxiY)

MouseLimit = 0
CALL MouseStatus(LeftButton, RightButton, xMouse, yMouse)

IF xMouse >= MiniX AND xMouse <= MiniX + MaxiX THEN
	IF yMouse >= MiniY AND yMouse <= MiniY + MaxiY THEN
		MouseLimit = -1
	END IF
END IF

END FUNCTION

'DEFLNG A-Z
SUB MousePut (X%, Y%)
  ax% = 4
  cx% = X%
  dx% = Y%
  mousedriver ax%, 0, cx%, dx%
END SUB

'DEFLNG A-Z
SUB MouseRange (x1%, y1%, x2%, y2%)
  ax% = 7
  cx% = x1%
  dx% = x2%
mousedriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = y1%
  dx% = y2%
  mousedriver ax%, 0, cx%, dx%
END SUB

'DEFLNG A-Z
SUB MouseShow
  ax% = 1
  mousedriver ax%, 0, 0, 0
END SUB

DEFLNG A-Z
'DEFINT A-Z
SUB MouseStatus (Lb%, Rb%, xMouse%, yMouse%)
  ax% = 3
  mousedriver ax%, bx%, cx%, dx%
  Lb% = ((bx% AND 1) <> 0)
  Rb% = ((bx% AND 2) <> 0)
  xMouse% = cx%
  yMouse% = dx%
END SUB

DEFINT A-Z
SUB MultiTasking.Driver (action)
'Portable MultiTasking Driver for QBGUI (c) 1997 Jonathan Thorpe
IF action = 1 THEN ' Add to Multitasking file
	CLOSE
	OPEN "multi.tsk" FOR INPUT AS #1
	DO
		INPUT #1, OBJNAME$, Execution$
		IF OBJNAME$ = "CD Player" AND Execution$ = "CDPLAYER.EXE" THEN
			EXIT SUB
		END IF
	LOOP UNTIL EOF(1)
	CLOSE
	OPEN "multi.tsk" FOR APPEND AS #1
	'WRITE #1, "[TASK MANAGEMENT FILE]", DATE$
	WRITE #1, "CD Player", "CDPLAYER.EXE"
	CLOSE
ELSEIF action = 2 THEN '  Check if this application is running a multitasker
	CLOSE
	OPEN "multi.tsk" FOR INPUT AS #1
	OPEN "tmp\multi.tmp" FOR OUTPUT AS #2
	DO
		INPUT #1, OBJNAME$, Execution$
		IF OBJNAME$ <> "CD Player" AND Execution$ <> "CDPLAYER.EXE" THEN
			WRITE #2, OBJNAME$, Execution$
		END IF
		LOOP UNTIL EOF(1)
	CLOSE
	OPEN "multi.tsk" FOR OUTPUT AS #1
	OPEN "tmp\multi.tmp" FOR INPUT AS #2
	DO
		INPUT #2, OBJNAME$, Execution$
		WRITE #1, OBJNAME$, Execution$
	LOOP UNTIL EOF(2)
	CLOSE
END IF
END SUB

SUB Place.Icon (X%, Y%, filename$)
DEF SEG = VARSEG(Button.Button(0))
	BLOAD filename$, VARPTR(Button.Button(0))
DEF SEG
PUT (X%, Y%), Button.Button, PSET

END SUB

DEFSNG A-Z
SUB Prepcb (code%) STATIC
' Prepares the control block for a given subfunction
' Checks whether cb() is used for IOCTL INPUT or OUTPUT
'
' ARGS: code%           - control block code
' RET:  - correctly dimensioned control block cb()
'       - correctly filled in fields for entire request
'         header
IF ASC(rh(3)) = 3 THEN
	SELECT CASE code%
		CASE 1
			length% = 6
		CASE 4
			length% = 9
		CASE 6
			length% = 5
		CASE 9
			length% = 2
		CASE 10, 11
			length% = 7
		CASE 12, 15
			length% = 11
	END SELECT
ELSE
	SELECT CASE code%
		CASE 0, 2, 5
			length% = 1
		CASE 1
			length% = 2
		CASE 3
			length% = 9
	END SELECT
	END IF

REDIM cb(1 TO length%) AS STRING * 1

cb(1) = CHR$(code%)

'Update address of cb() in rh()
rh(15) = CHR$(lbyte(VARPTR(cb(1))))
rh(16) = CHR$(hbyte(VARPTR(cb(1))))
rh(17) = CHR$(lbyte(VARSEG(cb(1))))
rh(18) = CHR$(hbyte(VARSEG(cb(1))))
'Number of bytes to transfer
rh(19) = CHR$(lbyte(length%))
rh(20) = CHR$(hbyte(length%))

END SUB

SUB Preprh (command%) STATIC
' Prepares the request header for a given command code
'
' ARGS: command%        - command code
' RET:  - correctly dimensioned request header rh()
'       - correctly filled in fields for basic request
'         header

SELECT CASE command%
	CASE 3, 12            'IOCTL Input , IOCTL Output
		rhlength% = 26
	CASE 132              'Play
		rhlength% = 22
	CASE 133, 136         'Pause, Resume
		rhlength% = 13
END SELECT

REDIM rh(1 TO rhlength%) AS STRING * 1
rh(1) = CHR$(rhlength%)
rh(2) = CHR$(drivearray(Drive, 2))
rh(3) = CHR$(command%)
END SUB

FUNCTION RBAtoHSG& (RBAMin%, RBASec%, RBAFrm%)
RBAtoHSG& = RBAMin% * 4500& + RBASec% * 75 + RBAFrm%
END FUNCTION

DEFINT A-Z
SUB RTQInfoz (track%, RTTrack&, RTDisk&, lowest%, highest%, r1, c1, c2)
	LOCATE r1, c2
	ct$ = LTRIM$(RTRIM$(STR$(track%)))
	IF LEN(ct$) = 1 THEN ct$ = "  " + ct$
	IF LEN(ct$) = 2 THEN ct$ = " " + ct$
	'PRINT "Current Track:  " + ct$
	CALL DisplayTrackPercent(RTTrack&, track%, lowest%, highest%)
  
	HSGtoRBA RTTrack&, RBAMin%, RBASec%, RBAFrm%
	LOCATE r1 + 1, c2
	'PRINT "Track Time "; : DisplayTime RBAMin%, RBASec%, RBAFrm%
	HSGtoRBA RTDisk&, RBAMin%, RBASec%, RBAFrm%
	'IF RBAFrm% < 0 AND highest% = lowest% THEN
	'    LOCATE 21, 1: COLOR 14, 4
	'    PRINT "CD-ROM found... exiting": END
	'END IF
	LOCATE r1 + 2, c2
	PRINT "Disk Time  "; : DisplayTime RBAMin%, RBASec%, RBAFrm%

END SUB

DEFSNG A-Z
SUB SCDAudioStatus (Paused%, start&, ending&)
'Returns the paused bit information, starting and
'ending location of last Play/next Resume command
'
'ARGS:  Variables to hold returned information
'RET:   paused%     - Paused bit
'       start&      - Start of last Play/next Resume
'       ending&     - End of last Play/next Resume
'       All addresses in HSG mode

Preprh 3
Prepcb 15
Call10

Paused% = BitCheck(0, ASC(cb(2)))
start& = RBAtoHSG(ASC(cb(6)), ASC(cb(5)) - 2, ASC(cb(4)))
ending& = RBAtoHSG(ASC(cb(10)), ASC(cb(9)) - 2, ASC(cb(8)))
END SUB

DEFINT A-Z
SUB SCDClose
'closes tray of CD
Preprh 12
Prepcb 5
Call10
END SUB

DEFSNG A-Z
FUNCTION SCDDeviceStatus%
'Get the dword which contains the parameters
'describing the status of the CD-ROM drive
'
'ARGS:  None
'RET:   Function value  - device parameters

'Device status
'
'DevStat   DB   6         ; Control block code
'      DD   ?         ; Device parameters
'
'The device driver will return a 32-bit value. Bit 0 is the least significant
'bit. The bits are interpreted as follows:
'
'  Bit 0     0    Door closed
'            1    Door open
'
'  Bit 1     0    Door locked
'            1    Door unlocked
'
'  Bit 2     0    Supports only cooked reading
'            1    Supports cooked and raw reading
'
'  Bit 3     0    Read only
'            1    Read/write
'
'  Bit 4     0    Data read only
'            1    Data read and plays audio/video tracks
'
'  Bit 5     0    No interleaving
'            1    Supports interleaving
'
'  Bit 6     0    Reserved
'
'  Bit 7     0    No prefetching
'            1    Supports prefetching requests
'
'  Bit 8     0    No audio channel manipulation
'            1    Supports audio channel manipulation
'
'  Bit 9     0    Supports HSG addressing mode
'            1    Supports HSG and Red Book addressing modes
'
'  Bit 10-31 0    Reserved (all 0)


Preprh 3
Prepcb 6
Call10
SCDDeviceStatus% = ASC(cb(2)) + ASC(cb(3)) * 256
END FUNCTION

SUB SCDDiskInfo (Low%, High%, Leadout&)
'Get general disk information
'
'ARGS:  Variables to return values to
'RET:   low%        - Lowest track on CD
'       high%       - Highest track on CD
'       leadout&    - HSG address of the lead-out
'                     track (end of disk)

Preprh 3
Prepcb 10
Call10
Low% = ASC(cb(2))
High% = ASC(cb(3))
Leadout& = RBAtoHSG(ASC(cb(6)), ASC(cb(5)) - 2, ASC(cb(4)))
END SUB

DEFINT A-Z
SUB SCDEject
'ejects a CD
Preprh 12
Prepcb 0
Call10
END SUB

DEFSNG A-Z
SUB SCDGetChannel (Ch0%, Vol0%, Ch1%, Vol1%, Ch2%, Vol2%, Ch3%, Vol3%)
'Read the input/ouput channel assignments and the
'volume levels for each output channel
'
'ARGS:  None
'RET:   Ch0     - Input channel assigned to ouput 0
'       Vol0    - Volume for output channel 0
'       **Same things for channels 1, 2, and 3**

Preprh 3
Prepcb 4
Call10
Ch0% = ASC(cb(2))
Vol0% = ASC(cb(3))
Ch1% = ASC(cb(4))
Vol1% = ASC(cb(5))
Ch2% = ASC(cb(6))
Vol2% = ASC(cb(7))
Ch3% = ASC(cb(8))
Vol3% = ASC(cb(9))
END SUB

FUNCTION SCDLocateHead&
' Determine the location of the drive head
'
' ARGS: None
' RET:  Function value  - HSG address of the drive
'                         heads' location

Preprh 3
Prepcb 1
cb(2) = CHR$(0)
Call10
SCDLocateHead& = ASC(cb(3)) + ASC(cb(4)) * 256& + ASC(cb(5)) * 256& ^ 2 + ASC(cb(6)) * 256& ^ 3
END FUNCTION

FUNCTION SCDMediaChanged%
'Check whether the media in a drive was changed
'
'ARGS:  None
'RET:   Function value:  1 = Media not changed
'                        0 = Don't know if changed
'                       -1 = Media Changed

Preprh 3
Prepcb 9
Call10

IF ASC(cb(2)) = 255 THEN
		SCDMediaChanged = -1
	ELSE
		SCDMediaChanged = ASC(cb(2))
	END IF
END FUNCTION

DEFINT A-Z
SUB SCDPause
'Pause the audio on the CD
'ARGS:  none
'RET:   none
Paused% = 1
Preprh 133
Call10
END SUB

DEFSNG A-Z
SUB SCDplay (BeginSec&, LengthSec&)
'Play the audio on the CD starting at start& for
'length& sectors
'
'ARGS:  start&      - Location where playback begins
'       length&     - Number of sectors to play
'RET:   none
Preprh 132
rh(14) = CHR$(0)
Byte BeginSec&, b1$, b2$, b3$, b4$
rh(15) = b4$
rh(16) = b3$
rh(17) = b2$
rh(18) = b1$

Byte LengthSec&, b1$, b2$, b3$, b4$
rh(19) = b4$
rh(20) = b3$
rh(21) = b2$
rh(22) = b1$
Call10
END SUB

DEFINT A-Z
SUB SCDQInfo (track%, RTTrack&, RTDisk&)
'Returns information directly from the Q-Channel
'
'ARGS:  Variables to hold returned information
'RET:   track%      - Track where head is at
'       RTtrack&    - Running time within track (HSG)
'       RTdisk&     - Running time within disk (HSG)
'       playing     - updated as a side effect

Preprh 3
Prepcb 12
Call10

track% = VAL(HEX$(ASC(cb(3)))) 'BCD -> decimal
IF track% = 0 THEN
	MouseHide
	GET (100, 100)-(350, 200), BehindDrag
	box 7, 100, 100, 350, 200, "CD-Player", 15, 0, 0, 0, 0, 0
	w "Please insert a CD into your", 120, 120, 0, 0, 0
	w "CD-ROM Drive (ESC = Abort).", 120, 130, 0, 0, 0
	DO
		Preprh 3
		Prepcb 12
		Call10
		track% = VAL(HEX$(ASC(cb(3)))) 'BCD -> decimal
		IF INKEY$ = CHR$(27) THEN
			SYSTEM
		END IF
	LOOP UNTIL track% <> 0
	PUT (100, 100), BehindDrag, PSET
	MouseShow
END IF
Preprh 3
Prepcb 12
Call10
track% = VAL(HEX$(ASC(cb(3)))) 'BCD -> decimal

'update playing variable
playing = BitCheck(1, ASC(rh(5)))

RTTrack& = RBAtoHSG(ASC(cb(5)), ASC(cb(6)), ASC(cb(7)))
RTDisk& = RBAtoHSG(ASC(cb(9)), ASC(cb(10)) - 2, ASC(cb(11)))
END SUB

SUB SCDReset
'Resets the CD-ROM drive
'
'ARGS:  none
'RET:   none

Preprh 12
Prepcb 2
Call10
END SUB

SUB SCDResume
'Resume the audio on the CD
'ARGS:  none
'RET:   none
Paused% = 0
Preprh 136
Call10

END SUB

DEFSNG A-Z
SUB SCDTrackInfo (track%, start&, ctrl%)
'Get specific track information
'
'ARGS:  track%      - track number you want info about
'       variables to return values to
'RET:   start&      - HSG address where the track begins
'       ctrl%       - track control information

Preprh 3
Prepcb 11
cb(2) = CHR$(track%)
Call10
start& = RBAtoHSG(ASC(cb(5)), ASC(cb(4)) - 2, ASC(cb(3)))
ctrl% = ASC(cb(7))
END SUB

DEFINT A-Z
SUB ShowTime (row, col)
hr = VAL(MID$(TIME$, 1, 2))
IF hr < 12 THEN ap$ = "am" ELSE ap$ = "pm"
hr = hr MOD 12
IF hr = 0 THEN hr = 12
hour$ = STR$(hr)
min$ = MID$(TIME$, 4, 2)
currtime$ = "Time: " + hour$ + ":" + min$ + ap$

LOCATE row, col
'COLOR 14, 2: PRINT currtime$
'COLOR 7, 0
END SUB

SUB w (a$, X%, Y%, Co%, Bkgd%, Shadow%)

DEFINT A-Z
extX% = 8: extY% = 0
DEF SEG = &HFFA6
 FOR I% = 1 TO LEN(a$)
   ADDR% = 8 * ASC(MID$(a$, I%)) + 14
IF Background% THEN
IF Background% = 256 THEN BG% = false ELSE BG% = Bkgd%
IF I% = LEN(a$) THEN extX% = false: extY% = false
LINE (X%, Y%)-(X% + 7 + extX%, Y% + 7 + extY%), BG%, BF
END IF
FOR j% = 0 TO 7: mask% = PEEK(ADDR% + j%) * 128
IF Shadow% THEN
IF Shadow% > 1 THEN
LINE (X% + 9, Y% + j% + 2)-(X% + 1, Y% + j% + 1), Shadow%, , mask%
ELSE
LINE (X% + 9, Y% + j% + 2)-(X% + 2, Y% + j% + 2), 0, , mask%
END IF
END IF
LINE (X% + 7, Y% + j%)-(X%, Y% + j%), Co%, , mask%
NEXT: X% = X% + extX%: Y% = Y% + extY%:  NEXT: DEF SEG
END SUB

